IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'dbo.CF_Producto_Facturado') 
                   and type = 'FN')
BEGIN
    DROP FUNCTION dbo.CF_Producto_Facturado
END
GO

CREATE FUNCTION dbo.CF_Producto_Facturado(@pId_Cliente INT, @pId_Producto VARCHAR(14), @pFechaDesde DATETIME, @pFechaHasta DATETIME) 
RETURNS INT
AS
BEGIN
DECLARE @Retorno INT
		,@FLAG_MES TINYINT
		,@FLAG_PERIODO TINYINT
		,@Estado_Proc_RECE INT




SELECT @FLAG_MES = ISNULL(FLAG_MES,0), @FLAG_PERIODO = ISNULL(FLAG_PERIODO,0) FROM Productos WHERE Id_Producto = @pId_Producto
SET @Estado_Proc_RECE = CAST(dbo.CF_xParam('Estado_Proc_RECE') AS INT)

IF @FLAG_MES <> 0
BEGIN
	SELECT @Retorno = (SELECT TOP 1 I.Id_trans FROM Cbtes_Items I, Cbtes C,Cbtes_Tipos T
							WHERE I.Id_Trans = C.Id_Trans
							AND C.Id_Tipo_Cbte = T.Id_Tipo_Cbte
							AND T.Compromete_Factura = 1
							AND ISNULL(I.Id_cliente,C.Id_Cliente) = @pId_Cliente
							AND I.Id_Producto = @pId_Producto
							AND C.Id_Estado_Cbte IN (1,2,4,@Estado_Proc_RECE)
							AND DATEPART(mm,I.Fecha_QA) = DATEPART(mm,@pFechaDesde)
							AND DATEPART(yy,I.Fecha_QA) = DATEPART(yy,@pFechaDesde)
					)
END
ELSE
BEGIN
	IF @FLAG_PERIODO <> 0
	BEGIN
		SELECT @Retorno = (SELECT TOP 1 I.Id_trans FROM Cbtes_Items I, Cbtes C,Cbtes_Tipos T
								WHERE I.Id_Trans = C.Id_Trans
								AND C.Id_Tipo_Cbte = T.Id_Tipo_Cbte
								AND T.Compromete_Factura = 1
								AND ISNULL(I.Id_cliente,C.Id_Cliente) = @pId_Cliente
								AND I.Id_Producto = @pId_Producto
								AND C.Id_Estado_Cbte IN (1,2,4,@Estado_Proc_RECE)
								AND @pFechaDesde <= ISNULL(I.Fecha_Venc,I.Fecha_QA)
								AND @pFechaHasta >= I.Fecha_QA
						)
	END
END
RETURN ISNULL(@Retorno,0)

END